﻿-- Thomas Elliott
-- Version: 1.3 - Release	
-- 8/19/2012

-- Creates Ace Object
PlayerFrameRemoval = LibStub("AceAddon-3.0"):NewAddon("PlayerFrameRemoval", "AceConsole-3.0")

-- Creates options menue for toggling visibility of player frame

local options = {
	name = "PlayerFrameRemoval",
	handler = PlayerFrameRemoval,
	type = 'group',
	args = {
		togglepf = {
			type = "execute",
			name = "Toggle Player Frame",
			desc = "Toggles player frame visibility.",
			func = "togPlayer",
		},	
		status = {
			type = "execute",
			name = "Player Frame Status",
			desc = "Displays visibility status on screen.",
			func = "status",
		},	
		toggletf = {
			type = "execute",
			name = "Toggle Target Frame",
			desc = "Toggles target frame visibility",
			func = "togTarget",
		},	
	},
}

-- Sets a default value for visibility when run for the first time on a profile
local defaults = {
	char = {
		visible = true,
		pfVisible = true,
		tfVisible = true,
		firstTime = 0,
	},
}



-- When the addon is loaded it creates a new AceDB if it doesn't already exist, registers the options table, and prints welcome message
function PlayerFrameRemoval:OnInitialize()
	
	self.db = LibStub("AceDB-3.0"):New("PFRDB", defaults, "Default")

	LibStub("AceConfig-3.0"):RegisterOptionsTable("PlayerFrameRemoval", options, {"playerframeremoval", "pfr"})
	
	self:Print("Thank you for using Player Frame Removal questions/comments/bugs feel free to email: tmelliottjr@yahoo.com \n Use the command /pfr for a list of options.")
	
	-- This tests whether or not this is the first time they have run this update (1.3) If it is it copies over the old settings if not it does nothing.
	if self.db.char.firstTime == 0 then
		self.db.char.pfVisible = self.db.char.visible
		self.db.char.firstTime = 1
		self:Print("Updating settings for Version 1.3")
	end
	
	-- Tests whether or not the saved variable is true or false to determine visibility of player frame
	if self.db.char.pfVisible then
		PlayerFrame:Show()
		PlayerFrame:SetScript("OnEvent", PlayerFrame_OnEvent);
	else 
		PlayerFrame:Hide()
		PlayerFrame:SetScript("OnEvent", nil);
	end
	
	-- Tests whether or not the saved variable is true or false to determine visibility of target frame	
	if self.db.char.tfVisible then
		TargetFrame:Show()
		TargetFrame:SetScript("OnEvent", TargetFrame_OnEvent);
	else 
		TargetFrame:Hide()
		TargetFrame:SetScript("OnEvent", nil);
	end
end

-- When toggled checks whether the player frame is visible or not and changes visibility appropriately
function PlayerFrameRemoval:togPlayer(info)
	if self.db.char.pfVisible then
		PlayerFrame:Hide()
		PlayerFrame:SetScript("OnEvent", nil);
		self.db.char.pfVisible = false
		self:Print("Player frame is now hidden.")
	else	
		PlayerFrame:Show()
		PlayerFrame:SetScript("OnEvent", PlayerFrame_OnEvent);
		self.db.char.pfVisible = true
		self:Print("Player frame is now visible.")
	end
end	

-- When toggled checks whether the target frame is visible or not and changes visibility appropriately
function PlayerFrameRemoval:togTarget(info)
	if self.db.char.tfVisible then
		TargetFrame:Hide()
		TargetFrame:SetScript("OnEvent", nil);
		self.db.char.tfVisible = false
		self:Print("Target frame is now hidden")
	else	
		TargetFrame:Show()
		TargetFrame:SetScript("OnEvent", TargetFrame_OnEvent);
		self.db.char.tfVisible = true
		self:Print("Target fram is now visible.")
	end
end

-- Checks status of visibility and displays it on the screen
function PlayerFrameRemoval:status(info)
	if self.db.char.pfVisible then
		self:Print("Player frame is visible.")
	else
		self:Print("Player frame is hidden.")
	end
	
	if self.db.char.tfVisible then
		self:Print("Target frame is visible.")
	else
		self:Print("Target frame is hidden.")
	end
	
end